/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.test.transform;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation
public class NotYetImplementedASTTransformation
extends AbstractASTTransformation {
    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        MethodNode methodNode = (MethodNode)nodes[1];
        AnnotationNode annotation = (AnnotationNode)nodes[0];
        ClassNode exception = this.getMemberClassValue(annotation, "exception");
        boolean withCause = false;
        if (exception == null) {
            exception = ClassHelper.make(AssertionError.class);
            withCause = true;
        } else {
            Parameter message = new Parameter(ClassHelper.STRING_TYPE, "message");
            ConstructorNode ctor = exception.getDeclaredConstructor(new Parameter[]{message});
            if (ctor == null || !ctor.isPublic()) {
                ctor = exception.getDeclaredConstructor(new Parameter[]{message, new Parameter(ClassHelper.THROWABLE_TYPE, "cause")});
                if (ctor != null && ctor.isPublic()) {
                    withCause = true;
                } else {
                    this.addError("Error during @NotYetImplemented processing: supplied exception " + exception.getNameWithoutPackage() + " doesn't have expected String constructor", methodNode);
                }
            }
        }
        if (methodNode.getCode() instanceof BlockStatement && !methodNode.getCode().isEmpty()) {
            TryCatchStatement tryCatchStatement = GeneralUtils.tryCatchS(methodNode.getCode(), EmptyStatement.INSTANCE, GeneralUtils.catchS(GeneralUtils.param(ClassHelper.THROWABLE_TYPE.getPlainNodeReference(), "ignore"), ReturnStatement.RETURN_NULL_OR_VOID));
            Expression arguments = GeneralUtils.constX("Method is marked with @NotYetImplemented but passes unexpectedly");
            if (withCause) {
                arguments = GeneralUtils.args(arguments, GeneralUtils.castX(ClassHelper.THROWABLE_TYPE, GeneralUtils.nullX()));
            }
            ThrowStatement throwStatement = GeneralUtils.throwS(GeneralUtils.ctorX(exception, arguments));
            methodNode.setCode(GeneralUtils.block(tryCatchStatement, throwStatement));
        }
    }
}

