/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.ginq.provider.collection.runtime;

import groovy.lang.Tuple2;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.groovy.ginq.provider.collection.runtime.Queryable;
import org.apache.groovy.ginq.provider.collection.runtime.QueryableCollection;
import org.apache.groovy.ginq.provider.collection.runtime.RowBound;
import org.apache.groovy.ginq.provider.collection.runtime.ValueBound;
import org.apache.groovy.ginq.provider.collection.runtime.Window;
import org.apache.groovy.ginq.provider.collection.runtime.WindowDefinition;
import org.apache.groovy.util.ReversedList;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberPlus;
import org.codehaus.groovy.runtime.typehandling.NumberMath;

class WindowImpl<T, U extends Comparable<? super U>>
extends QueryableCollection<T>
implements Window<T> {
    private final Tuple2<T, Long> currentRecord;
    private final Queryable.Order<? super T, ? extends U> order;
    private final Comparator<? super T> comparator;
    private final int index;
    private final U value;
    private final List<T> list;
    private static final BigDecimal MIN_VALUE = NumberMath.toBigDecimal(Long.MIN_VALUE);
    private static final BigDecimal MAX_VALUE = NumberMath.toBigDecimal(Long.MAX_VALUE);
    private static final long serialVersionUID = -3458969297047398621L;

    WindowImpl(Tuple2<T, Long> currentRecord, int index, U value, List<T> list, Queryable.Order<? super T, ? extends U> order) {
        super(list);
        this.currentRecord = currentRecord;
        this.order = order;
        this.comparator = null == order ? null : WindowImpl.makeComparator(order);
        this.index = index;
        this.value = value;
        this.list = list;
    }

    @Override
    public long rowNumber() {
        return this.index;
    }

    @Override
    public <V> V lead(Function<? super T, ? extends V> extractor, long lead, V def) {
        V field = 0L == lead ? extractor.apply(this.currentRecord.getV1()) : (0L <= (long)this.index + lead && (long)this.index + lead < (long)this.list.size() ? extractor.apply(this.list.get(this.index + (int)lead)) : def);
        return field;
    }

    @Override
    public <V> V lag(Function<? super T, ? extends V> extractor, long lag, V def) {
        return this.lead(extractor, -lag, def);
    }

    @Override
    public <V> V firstValue(Function<? super T, ? extends V> extractor) {
        return this.nthValue(extractor, 0L);
    }

    @Override
    public <V> V lastValue(Function<? super T, ? extends V> extractor) {
        int size = this.list.size();
        if (0 == size) {
            return null;
        }
        return this.nthValue(extractor, size - 1);
    }

    @Override
    public <V> V nthValue(Function<? super T, ? extends V> extractor, long index) {
        if (index < 0L) {
            throw new IllegalArgumentException("index cannot be less than 0: " + index);
        }
        if (index > (long)(this.list.size() - 1)) {
            return null;
        }
        return extractor.apply(this.list.get((int)index));
    }

    @Override
    public Long rank() {
        if (null == this.order) {
            return null;
        }
        long result = 1L;
        for (T t : this.list) {
            if (this.comparator.compare(this.currentRecord.getV1(), t) <= 0) continue;
            ++result;
        }
        return result;
    }

    @Override
    public Long denseRank() {
        if (null == this.order) {
            return null;
        }
        long result = 1L;
        Object latest = null;
        for (T t : this.list) {
            if (this.comparator.compare(this.currentRecord.getV1(), t) > 0 && this.comparator.compare(latest, t) != 0) {
                ++result;
            }
            latest = t;
        }
        return result;
    }

    @Override
    public BigDecimal percentRank() {
        if (null == this.order) {
            return null;
        }
        int size = this.list.size();
        if (1 == size) {
            return BigDecimal.ONE;
        }
        Long r = this.rank();
        if (null == r) {
            return null;
        }
        return NumberMath.toBigDecimal(r - 1L).divide(NumberMath.toBigDecimal(size - 1), 16, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal cumeDist() {
        if (null == this.order) {
            return null;
        }
        long cnt = this.list.stream().filter(e -> this.comparator.compare(this.currentRecord.getV1(), e) >= 0).count();
        return NumberMath.toBigDecimal(cnt).divide(NumberMath.toBigDecimal(this.list.size()), 16, RoundingMode.HALF_UP);
    }

    @Override
    public long ntile(long bucketCnt) {
        return bucketCnt * this.rowNumber() / (long)this.list.size();
    }

    private static <T, U extends Comparable<? super U>> long getFirstIndex(WindowDefinition<T, U> windowDefinition, int index) {
        RowBound rowBound = windowDefinition.rows();
        Long lower = (Long)rowBound.getLower();
        return null == lower || Long.MIN_VALUE == lower ? 0L : (long)index + lower;
    }

    private static <T, U extends Comparable<? super U>> long getLastIndex(WindowDefinition<T, U> windowDefinition, int index, long size) {
        RowBound rowBound = windowDefinition.rows();
        Long upper = (Long)rowBound.getUpper();
        return null == upper || Long.MAX_VALUE == upper ? size - 1L : (long)index + upper;
    }

    static <T, U extends Comparable<? super U>> RowBound getValidRowBound(WindowDefinition<T, U> windowDefinition, int index, U value, List<Tuple2<T, Long>> listWithIndex) {
        int size = listWithIndex.size();
        long firstIndex = 0L;
        long lastIndex = size - 1;
        if (null != windowDefinition.rows() && RowBound.DEFAULT != windowDefinition.rows()) {
            firstIndex = WindowImpl.getFirstIndex(windowDefinition, index);
            lastIndex = WindowImpl.getLastIndex(windowDefinition, index, size);
        } else if (null != windowDefinition.range() && null != windowDefinition.orderBy()) {
            List<Queryable.Order<T, U>> orderList;
            ValueBound<U> valueBound = windowDefinition.range();
            Comparable lower = (Comparable)valueBound.getLower();
            Comparable upper = (Comparable)valueBound.getUpper();
            if (value instanceof Number && (lower instanceof Number || null == lower) && (upper instanceof Number || null == upper) && (orderList = windowDefinition.orderBy()).size() == 1) {
                BigDecimal upperValue;
                Queryable.Order order = orderList.get(0);
                if (listWithIndex.isEmpty()) {
                    return null;
                }
                int flag = order.isAsc() ? 1 : -1;
                BigDecimal firstElement = NumberMath.toBigDecimal((Number)order.getKeyExtractor().apply(listWithIndex.get(0).getV1()));
                BigDecimal lastElement = NumberMath.toBigDecimal((Number)order.getKeyExtractor().apply(listWithIndex.get(size - 1).getV1()));
                BigDecimal lowerValue = null == lower ? MIN_VALUE : NumberMath.toBigDecimal(NumberNumberPlus.plus((Number)((Object)value), (Number)((Object)lower)));
                BigDecimal bigDecimal = upperValue = null == upper ? MAX_VALUE : NumberMath.toBigDecimal(NumberNumberPlus.plus((Number)((Object)value), (Number)((Object)upper)));
                if (flag * lowerValue.compareTo(firstElement) < 0 && flag * upperValue.compareTo(firstElement) < 0 || flag * lowerValue.compareTo(lastElement) > 0 && flag * upperValue.compareTo(lastElement) > 0) {
                    return null;
                }
                List list = listWithIndex.stream().map(e -> (Comparable)order.getKeyExtractor().apply(e.getV1())).collect(Collectors.toList());
                if (order.isAsc()) {
                    firstIndex = WindowImpl.getIndexByValue(lowerValue, true, list);
                    lastIndex = WindowImpl.getIndexByValue(upperValue, false, list);
                } else {
                    ReversedList reversedList = new ReversedList(list);
                    lastIndex = (long)(size - 1) - WindowImpl.getIndexByValue(lowerValue, true, reversedList);
                    firstIndex = (long)(size - 1) - WindowImpl.getIndexByValue(upperValue, false, reversedList);
                }
            }
        }
        if (firstIndex < 0L && lastIndex < 0L || firstIndex >= (long)size && lastIndex >= (long)size) {
            return null;
        }
        return new RowBound(Math.max(firstIndex, 0L), Math.min(lastIndex, (long)(size - 1)));
    }

    private static <T, U extends Comparable<? super U>> long getIndexByValue(BigDecimal value, boolean isLower, List<U> list) {
        int valueIndex;
        int tmpIndex = Collections.binarySearch(list, value, Comparator.comparing(u -> NumberMath.toBigDecimal((Number)((Object)u))));
        if (tmpIndex >= 0) {
            valueIndex = tmpIndex;
        } else {
            valueIndex = -tmpIndex - 1;
            if (!isLower && --valueIndex < 0) {
                valueIndex = 0;
            }
        }
        if (isLower) {
            int i;
            for (i = valueIndex - 1; i >= 0 && value.equals(NumberMath.toBigDecimal((Number)list.get(i))); --i) {
            }
            valueIndex = i + 1;
        } else {
            int i;
            int n = list.size();
            for (i = valueIndex + 1; i < n && value.equals(NumberMath.toBigDecimal((Number)list.get(i))); ++i) {
            }
            valueIndex = i - 1;
        }
        return valueIndex;
    }

    static <T, U extends Comparable<? super U>> List<Queryable.Order<Tuple2<T, Long>, U>> composeOrders(List<Queryable.Order<? super T, ? extends U>> orderList) {
        return orderList.stream().map(order -> new Queryable.Order<Tuple2, Comparable>(t -> (Comparable)order.getKeyExtractor().apply(t.getV1()), order.isAsc(), order.isNullsLast())).collect(Collectors.toList());
    }

    static <T, U extends Comparable<? super U>> List<Queryable.Order<Tuple2<T, Long>, U>> composeOrders(WindowDefinition<T, U> windowDefinition) {
        return WindowImpl.composeOrders(windowDefinition.orderBy());
    }
}

