/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.SourceUnit;

public final class ExpressionUtils {
    private ExpressionUtils() {
    }

    public static List<BooleanExpression> getBooleanExpression(ClosureExpression closureExpression) {
        if (closureExpression == null) {
            return null;
        }
        BlockStatement closureBlockStatement = (BlockStatement)closureExpression.getCode();
        return ExpressionUtils.getBooleanExpressions(closureBlockStatement);
    }

    private static List<BooleanExpression> getBooleanExpressions(BlockStatement closureBlockStatement) {
        List<Statement> statementList = closureBlockStatement.getStatements();
        ArrayList<BooleanExpression> booleanExpressions = new ArrayList<BooleanExpression>();
        for (Statement stmt : statementList) {
            BooleanExpression tmp = null;
            if (stmt instanceof ExpressionStatement && ((ExpressionStatement)stmt).getExpression() instanceof BooleanExpression) {
                tmp = (BooleanExpression)((ExpressionStatement)stmt).getExpression();
                ExpressionUtils.saveLabel(tmp, stmt);
            } else if (stmt instanceof ExpressionStatement) {
                Expression expression = ((ExpressionStatement)stmt).getExpression();
                tmp = GeneralUtils.boolX(expression);
                tmp.setSourcePosition(expression);
                ExpressionUtils.saveLabel(tmp, stmt);
            }
            booleanExpressions.add(tmp);
        }
        return booleanExpressions;
    }

    private static void saveLabel(BooleanExpression tmp, Statement stmt) {
        List<String> labels = stmt.getStatementLabels();
        tmp.setNodeMetaData("statementLabel", labels != null && !labels.isEmpty() ? labels.get(0) : null);
    }

    public static List<BooleanExpression> getBooleanExpressionsFromAssertionStatements(BlockStatement blockStatement) {
        AssertStatementCollector collector = new AssertStatementCollector();
        collector.visitBlockStatement(blockStatement);
        List<AssertStatement> assertStatements = collector.assertStatements;
        if (assertStatements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BooleanExpression> booleanExpressions = new ArrayList<BooleanExpression>();
        for (AssertStatement assertStatement : assertStatements) {
            booleanExpressions.add(assertStatement.getBooleanExpression());
        }
        return booleanExpressions;
    }

    public static BooleanExpression getBooleanExpression(List<BooleanExpression> booleanExpressions) {
        if (booleanExpressions == null || booleanExpressions.isEmpty()) {
            return GeneralUtils.boolX(ConstantExpression.TRUE);
        }
        BooleanExpression result = null;
        for (BooleanExpression booleanExpression : booleanExpressions) {
            if (result == null) {
                result = booleanExpression;
                continue;
            }
            result = GeneralUtils.boolX(GeneralUtils.andX(result, booleanExpression));
        }
        return result;
    }

    static class AssertStatementCollector
    extends ClassCodeVisitorSupport {
        public List<AssertStatement> assertStatements = new ArrayList<AssertStatement>();

        AssertStatementCollector() {
        }

        @Override
        public void visitAssertStatement(AssertStatement statement) {
            this.assertStatements.add(statement);
        }

        @Override
        protected SourceUnit getSourceUnit() {
            return null;
        }
    }
}

