/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.generation;

import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;

public class TryCatchBlockGenerator {
    public static BlockStatement generateTryCatchBlockForInlineMode(ClassNode assertionErrorClass, String message, Statement assertStatement) {
        Class powerAssertionErrorClass = TryCatchBlockGenerator.loadPowerAssertionErrorClass();
        if (powerAssertionErrorClass == null) {
            throw new GroovyBugError("groovy-contracts needs Groovy 1.7 or above!");
        }
        VariableExpression newError = GeneralUtils.localVarX("newError", assertionErrorClass);
        BlockStatement block = GeneralUtils.block(GeneralUtils.declS(newError, GeneralUtils.ctorX(assertionErrorClass, GeneralUtils.args(GeneralUtils.binX(GeneralUtils.constX(message), GeneralUtils.PLUS, GeneralUtils.callX(GeneralUtils.varX(GeneralUtils.param(ClassHelper.makeWithoutCaching(powerAssertionErrorClass), "error")), "getMessage"))))), GeneralUtils.stmt(GeneralUtils.callX((Expression)newError, "setStackTrace", (Expression)GeneralUtils.args(GeneralUtils.callX(GeneralUtils.varX(GeneralUtils.param(ClassHelper.makeWithoutCaching(powerAssertionErrorClass), "error")), "getStackTrace")))), GeneralUtils.throwS(newError));
        CatchStatement catchStatement = GeneralUtils.catchS(GeneralUtils.param(ClassHelper.makeWithoutCaching(powerAssertionErrorClass), "error"), block);
        return GeneralUtils.block(GeneralUtils.tryCatchS(assertStatement, EmptyStatement.INSTANCE, catchStatement));
    }

    public static BlockStatement generateTryCatchBlock(ClassNode assertionErrorClass, String message, Statement assertStatement) {
        String $_gc_closure_result = "$_gc_closure_result";
        VariableExpression variableExpression = GeneralUtils.localVarX("$_gc_closure_result", ClassHelper.Boolean_TYPE);
        BlockStatement overallBlock = GeneralUtils.block(GeneralUtils.declS(variableExpression, ConstantExpression.FALSE));
        BlockStatement assertBlockStatement = GeneralUtils.block(assertStatement, GeneralUtils.assignS(variableExpression, ConstantExpression.TRUE));
        Class powerAssertionErrorClass = TryCatchBlockGenerator.loadPowerAssertionErrorClass();
        if (powerAssertionErrorClass == null) {
            throw new GroovyBugError("groovy-contracts needs Groovy 1.7 or above!");
        }
        VariableExpression newErrorVariableExpression = GeneralUtils.localVarX("newError", assertionErrorClass);
        Statement expr = GeneralUtils.declS(newErrorVariableExpression, GeneralUtils.ctorX(assertionErrorClass, GeneralUtils.args(GeneralUtils.binX(GeneralUtils.constX(message), GeneralUtils.PLUS, GeneralUtils.callX(GeneralUtils.varX(GeneralUtils.param(ClassHelper.makeWithoutCaching(powerAssertionErrorClass), "error")), "getMessage")))));
        Statement exp2 = GeneralUtils.stmt(GeneralUtils.callX((Expression)newErrorVariableExpression, "setStackTrace", (Expression)GeneralUtils.args(GeneralUtils.callX(GeneralUtils.varX(GeneralUtils.param(ClassHelper.makeWithoutCaching(powerAssertionErrorClass), "error")), "getStackTrace"))));
        TryCatchStatement tryCatchStatement = GeneralUtils.tryCatchS(assertBlockStatement, EmptyStatement.INSTANCE, GeneralUtils.catchS(GeneralUtils.param(ClassHelper.makeWithoutCaching(powerAssertionErrorClass), "error"), GeneralUtils.block(expr, exp2)));
        overallBlock.addStatement(tryCatchStatement);
        overallBlock.addStatement(GeneralUtils.returnS(variableExpression));
        return overallBlock;
    }

    private static Class loadPowerAssertionErrorClass() {
        Class<?> result = null;
        try {
            result = TryCatchBlockGenerator.class.getClassLoader().loadClass("org.codehaus.groovy.transform.powerassert.PowerAssertionError");
        }
        catch (ClassNotFoundException e) {
            try {
                result = TryCatchBlockGenerator.class.getClassLoader().loadClass("org.codehaus.groovy.runtime.powerassert.PowerAssertionError");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return result;
    }
}

