/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.generation;

import java.util.List;
import java.util.Map;
import org.apache.groovy.contracts.annotations.meta.Postcondition;
import org.apache.groovy.contracts.generation.AssertStatementCreationUtility;
import org.apache.groovy.contracts.generation.BaseGenerator;
import org.apache.groovy.contracts.generation.OldVariableGenerationUtility;
import org.apache.groovy.contracts.util.AnnotationUtils;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.io.ReaderSource;

public class PostconditionGenerator
extends BaseGenerator {
    private static final String METHOD_PROCESSED = "org.apache.groovy.contracts.POSTCONDITION_PROCESSED";

    public PostconditionGenerator(ReaderSource source) {
        super(source);
    }

    public void addOldVariablesMethod(ClassNode classNode) {
        OldVariableGenerationUtility.addOldVariableMethodNode(classNode);
    }

    public void generatePostconditionAssertionStatement(MethodNode method, org.apache.groovy.contracts.domain.Postcondition postcondition) {
        BooleanExpression postconditionBooleanExpression = this.addCallsToSuperMethodNodeAnnotationClosure(method.getDeclaringClass(), method, Postcondition.class, postcondition.booleanExpression(), true);
        BlockStatement originalBlockStatement = postcondition.originalBlockStatement();
        boolean useExecutionTracker = originalBlockStatement == null || Boolean.TRUE.equals(originalBlockStatement.getNodeMetaData("org.apache.groovy.contracts.META_DATA.USE_EXECUTION_TRACKER"));
        BlockStatement blockStatement = !useExecutionTracker && Boolean.TRUE.equals(method.getNodeMetaData("org.apache.groovy.contracts.USE_INLINE_MODE")) ? this.getInlineModeBlockStatement(originalBlockStatement) : this.wrapAssertionBooleanExpression(method.getDeclaringClass(), method, postconditionBooleanExpression, "postcondition");
        this.addPostcondition(method, blockStatement);
    }

    public void generateDefaultPostconditionStatement(ClassNode type, MethodNode method) {
        boolean noPostconditionInHierarchy = AnnotationUtils.getAnnotationNodeInHierarchyWithMetaAnnotation(type.getSuperClass(), method, ClassHelper.makeWithoutCaching(Postcondition.class)).isEmpty();
        if (noPostconditionInHierarchy) {
            return;
        }
        BooleanExpression postconditionBooleanExpression = this.addCallsToSuperMethodNodeAnnotationClosure(method.getDeclaringClass(), method, Postcondition.class, GeneralUtils.boolX(ConstantExpression.TRUE), true);
        if (postconditionBooleanExpression.getExpression() == ConstantExpression.TRUE) {
            return;
        }
        BlockStatement blockStatement = this.wrapAssertionBooleanExpression(type, method, postconditionBooleanExpression, "postcondition");
        this.addPostcondition(method, blockStatement);
    }

    private void addPostcondition(MethodNode method, BlockStatement postconditionBlockStatement) {
        if (Boolean.TRUE.equals(method.getNodeMetaData(METHOD_PROCESSED))) {
            return;
        }
        BlockStatement block = (BlockStatement)method.getCode();
        List<Statement> statements = block.getStatements();
        if (!statements.isEmpty()) {
            VariableExpression contractsEnabled = GeneralUtils.localVarX("$GCONTRACTS_ENABLED", ClassHelper.boolean_TYPE);
            if (!ClassHelper.isPrimitiveVoid(method.getReturnType())) {
                List<ReturnStatement> returnStatements = AssertStatementCreationUtility.getReturnStatements(method);
                for (ReturnStatement returnStatement : returnStatements) {
                    BlockStatement localPostconditionBlockStatement = GeneralUtils.block(new VariableScope(), postconditionBlockStatement.getStatements());
                    VariableExpression result = GeneralUtils.localVarX("result", method.getReturnType());
                    localPostconditionBlockStatement.getStatements().add(0, GeneralUtils.declS(result, returnStatement.getExpression()));
                    AssertStatementCreationUtility.injectResultVariableReturnStatementAndAssertionCallStatement(block, method.getReturnType().redirect(), returnStatement, localPostconditionBlockStatement);
                }
                this.setOldVariablesIfEnabled(block, contractsEnabled);
            } else if (method instanceof ConstructorNode) {
                block.addStatements(postconditionBlockStatement.getStatements());
            } else {
                this.setOldVariablesIfEnabled(block, contractsEnabled);
                block.addStatements(postconditionBlockStatement.getStatements());
            }
            method.putNodeMetaData(METHOD_PROCESSED, true);
        }
    }

    private void setOldVariablesIfEnabled(BlockStatement block, Expression contractsEnabled) {
        VariableExpression oldVariableExpression = GeneralUtils.localVarX("old", new ClassNode(Map.class));
        Statement oldVariableStatement = GeneralUtils.assignS(oldVariableExpression, GeneralUtils.callThisX("$_gc_computeOldVariables"));
        block.getStatements().add(0, GeneralUtils.declS(oldVariableExpression, ConstantExpression.NULL));
        block.getStatements().add(1, GeneralUtils.ifS((Expression)GeneralUtils.boolX(contractsEnabled), GeneralUtils.block(oldVariableStatement)));
    }
}

