/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.generation;

import java.util.List;
import org.apache.groovy.contracts.annotations.meta.ClassInvariant;
import org.apache.groovy.contracts.ast.visitor.BaseVisitor;
import org.apache.groovy.contracts.generation.AssertStatementCreationUtility;
import org.apache.groovy.contracts.generation.BaseGenerator;
import org.apache.groovy.contracts.util.AnnotationUtils;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.io.ReaderSource;

public class ClassInvariantGenerator
extends BaseGenerator {
    private static final ClassNode CLASS_INVARIANT_TYPE = ClassHelper.makeWithoutCaching(ClassInvariant.class);

    public ClassInvariantGenerator(ReaderSource source) {
        super(source);
    }

    public void generateInvariantAssertionStatement(ClassNode type, org.apache.groovy.contracts.domain.ClassInvariant classInvariant) {
        BooleanExpression classInvariantExpression = this.addCallsToSuperAnnotationClosure(type, classInvariant.booleanExpression());
        BlockStatement blockStatement = GeneralUtils.block(new Statement[0]);
        MethodNode methodNode = type.addMethod(ClassInvariantGenerator.getInvariantMethodName(type), 4100, ClassHelper.VOID_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, blockStatement);
        methodNode.setSynthetic(true);
        blockStatement.addStatements(this.wrapAssertionBooleanExpression(type, methodNode, classInvariantExpression, "invariant").getStatements());
    }

    private BooleanExpression addCallsToSuperAnnotationClosure(ClassNode type, BooleanExpression booleanExpression) {
        List<AnnotationNode> contractElementAnnotations = AnnotationUtils.getAnnotationNodeInHierarchyWithMetaAnnotation(type.getSuperClass(), CLASS_INVARIANT_TYPE);
        for (AnnotationNode contractElementAnnotation : contractElementAnnotations) {
            booleanExpression = GeneralUtils.boolX(GeneralUtils.andX(booleanExpression, BaseVisitor.asConditionExecution(contractElementAnnotation)));
        }
        return booleanExpression;
    }

    public void addInvariantAssertionStatement(ClassNode type, MethodNode method) {
        String invariantMethodName = ClassInvariantGenerator.getInvariantMethodName(type);
        MethodNode invariantMethod = type.getDeclaredMethod(invariantMethodName, Parameter.EMPTY_ARRAY);
        if (invariantMethod == null) {
            return;
        }
        Statement invariantMethodCall = GeneralUtils.stmt(GeneralUtils.callThisX(invariantMethod.getName()));
        Statement statement = method.getCode();
        if (statement instanceof BlockStatement && !ClassHelper.isPrimitiveVoid(method.getReturnType()) && !(method instanceof ConstructorNode)) {
            BlockStatement blockStatement = (BlockStatement)statement;
            List<ReturnStatement> returnStatements = AssertStatementCreationUtility.getReturnStatements(method);
            for (ReturnStatement returnStatement : returnStatements) {
                AssertStatementCreationUtility.addAssertionCallStatementToReturnStatement(blockStatement, returnStatement, invariantMethodCall);
            }
            if (returnStatements.isEmpty()) {
                blockStatement.addStatement(invariantMethodCall);
            }
        } else if (statement instanceof BlockStatement) {
            BlockStatement blockStatement = (BlockStatement)statement;
            blockStatement.addStatement(invariantMethodCall);
        } else {
            BlockStatement assertionBlock = GeneralUtils.block(statement, invariantMethodCall);
            method.setCode(assertionBlock);
        }
    }
}

