/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.generation;

import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.groovy.contracts.ViolationTracker;
import org.apache.groovy.contracts.ast.visitor.BaseVisitor;
import org.apache.groovy.contracts.generation.ContractExecutionTracker;
import org.apache.groovy.contracts.util.AnnotationUtils;
import org.apache.groovy.contracts.util.ExpressionUtils;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.io.ReaderSource;

public abstract class BaseGenerator {
    public static final String INVARIANT_CLOSURE_PREFIX = "invariant";
    public static final String META_DATA_USE_INLINE_MODE = "org.apache.groovy.contracts.USE_INLINE_MODE";
    protected final ReaderSource source;

    protected BaseGenerator(ReaderSource source) {
        this.source = source;
    }

    public static String getInvariantMethodName(ClassNode classNode) {
        return "invariant_" + classNode.getName().replaceAll("\\.", "_");
    }

    public static MethodNode getInvariantMethodNode(ClassNode classNode) {
        return classNode.getDeclaredMethod(BaseGenerator.getInvariantMethodName(classNode), Parameter.EMPTY_ARRAY);
    }

    protected BlockStatement getInlineModeBlockStatement(BlockStatement blockStatement) {
        BooleanExpression combinedBooleanExpression = ExpressionUtils.getBooleanExpression(ExpressionUtils.getBooleanExpressionsFromAssertionStatements(blockStatement));
        return GeneralUtils.block(GeneralUtils.ifS((Expression)GeneralUtils.boolX(GeneralUtils.varX("$GCONTRACTS_ENABLED", ClassHelper.boolean_TYPE)), GeneralUtils.block(GeneralUtils.ifS((Expression)GeneralUtils.notX(combinedBooleanExpression), blockStatement))));
    }

    protected BlockStatement wrapAssertionBooleanExpression(ClassNode type, MethodNode methodNode, BooleanExpression classInvariantExpression, String assertionType) {
        ClassNode violationTrackerClassNode = ClassHelper.makeWithoutCaching(ViolationTracker.class);
        VariableExpression gcResult = GeneralUtils.varX("$_gc_result", ClassHelper.boolean_TYPE);
        gcResult.setAccessedVariable(gcResult);
        BlockStatement ifBlockStatement = GeneralUtils.block(GeneralUtils.declS(gcResult, ConstantExpression.FALSE), GeneralUtils.stmt(GeneralUtils.callX(GeneralUtils.classX(violationTrackerClassNode), "init")), GeneralUtils.assignS(gcResult, classInvariantExpression), GeneralUtils.ifS((Expression)GeneralUtils.boolX(GeneralUtils.notX(GeneralUtils.callX(gcResult, "booleanValue"))), GeneralUtils.ifS((Expression)GeneralUtils.boolX(GeneralUtils.callX(GeneralUtils.classX(violationTrackerClassNode), "violationsOccurred")), GeneralUtils.tryCatchS(GeneralUtils.stmt(GeneralUtils.callX(GeneralUtils.classX(violationTrackerClassNode), "rethrowFirst")), GeneralUtils.block(GeneralUtils.stmt(GeneralUtils.callX(GeneralUtils.classX(violationTrackerClassNode), "deinit")))))));
        TryCatchStatement lockTryCatchStatement = GeneralUtils.tryCatchS(GeneralUtils.ifS((Expression)GeneralUtils.boolX(GeneralUtils.callX((Expression)GeneralUtils.classX(ClassHelper.make(ContractExecutionTracker.class)), "track", (Expression)GeneralUtils.args(GeneralUtils.constX(type.getName()), GeneralUtils.constX(methodNode.getTypeDescriptor()), GeneralUtils.constX(assertionType), methodNode.isStatic() ? ConstantExpression.TRUE : ConstantExpression.FALSE))), ifBlockStatement), GeneralUtils.block(new VariableScope(), GeneralUtils.stmt(GeneralUtils.callX((Expression)GeneralUtils.classX(ClassHelper.make(ContractExecutionTracker.class)), "clear", (Expression)GeneralUtils.args(GeneralUtils.constX(type.getName()), GeneralUtils.constX(methodNode.getTypeDescriptor()), GeneralUtils.constX(assertionType), methodNode.isStatic() ? ConstantExpression.TRUE : ConstantExpression.FALSE)))));
        return GeneralUtils.block(GeneralUtils.ifS((Expression)GeneralUtils.boolX(GeneralUtils.varX("$GCONTRACTS_ENABLED", ClassHelper.boolean_TYPE)), lockTryCatchStatement));
    }

    protected BooleanExpression addCallsToSuperMethodNodeAnnotationClosure(ClassNode type, MethodNode methodNode, Class<? extends Annotation> annotationType, BooleanExpression booleanExpression, boolean isPostcondition) {
        List<AnnotationNode> contractElementAnnotations = AnnotationUtils.getAnnotationNodeInHierarchyWithMetaAnnotation(type.getSuperClass(), methodNode, ClassHelper.makeWithoutCaching(annotationType));
        if (contractElementAnnotations.isEmpty()) {
            methodNode.putNodeMetaData(META_DATA_USE_INLINE_MODE, Boolean.TRUE);
        } else {
            BooleanExpression collectedPre = null;
            for (AnnotationNode contractElementAnnotation : contractElementAnnotations) {
                ArgumentListExpression argumentList = new ArgumentListExpression();
                for (Parameter parameter : methodNode.getParameters()) {
                    argumentList.addExpression(GeneralUtils.varX(parameter));
                }
                if (isPostcondition && !methodNode.isVoidMethod()) {
                    argumentList.addExpression(GeneralUtils.localVarX("result", methodNode.getReturnType()));
                }
                if (isPostcondition && !methodNode.isConstructor()) {
                    argumentList.addExpression(GeneralUtils.localVarX("old", ClassHelper.MAP_TYPE.getPlainNodeReference()));
                }
                BooleanExpression predicate = BaseVisitor.asConditionExecution(contractElementAnnotation);
                ((MethodCallExpression)predicate.getExpression()).setArguments(argumentList);
                if (isPostcondition) {
                    booleanExpression = GeneralUtils.boolX(GeneralUtils.andX(booleanExpression, predicate));
                    continue;
                }
                if (collectedPre == null) {
                    collectedPre = predicate;
                    continue;
                }
                collectedPre = GeneralUtils.boolX(GeneralUtils.andX(collectedPre, predicate));
            }
            if (collectedPre != null) {
                booleanExpression = GeneralUtils.boolX(GeneralUtils.orX(booleanExpression, collectedPre));
            }
        }
        return booleanExpression;
    }
}

