/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.classgen.asm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;

public class ContractClosureWriter {
    private int closureCount = 1;

    public ClassNode createClosureClass(ClassNode classNode, MethodNode methodNode, ClosureExpression expression, boolean addOldVariable, boolean addResultVariable, int mods) {
        ClassNode outerClass = this.getOutermostClass(classNode);
        String name = outerClass.getName() + "$" + this.getClosureInnerName(outerClass, classNode);
        ArrayList<Parameter> parametersTemp = new ArrayList<Parameter>(Arrays.asList(expression.getParameters()));
        this.removeParameter("old", parametersTemp);
        this.removeParameter("result", parametersTemp);
        if (methodNode != null && addResultVariable && !ClassHelper.isPrimitiveVoid(methodNode.getReturnType())) {
            parametersTemp.add(new Parameter(methodNode.getReturnType(), "result"));
        }
        if (addOldVariable) {
            parametersTemp.add(new Parameter(new ClassNode(Map.class), "old"));
        }
        ArrayList<Parameter> closureParameters = new ArrayList<Parameter>();
        for (Parameter param : parametersTemp) {
            closureParameters.add(new Parameter(param.getType().getPlainNodeReference(), param.getName()));
        }
        ClassNode answer = new ClassNode(name, mods | 0x10, ClassHelper.CLOSURE_TYPE.getPlainNodeReference());
        answer.setSourcePosition(expression);
        answer.setSynthetic(true);
        MethodNode doCall = answer.addMethod("doCall", 1, ClassHelper.Boolean_TYPE, closureParameters.toArray(Parameter.EMPTY_ARRAY), ClassNode.EMPTY_ARRAY, expression.getCode());
        doCall.setSourcePosition(expression);
        VariableScope varScope = expression.getVariableScope();
        if (varScope == null) {
            throw new RuntimeException("Must have a VariableScope by now! for expression: " + expression + " class: " + name);
        }
        doCall.setVariableScope(varScope.copy());
        ArgumentListExpression arguments = new ArgumentListExpression();
        for (Parameter parameter : closureParameters) {
            arguments.addExpression(GeneralUtils.varX(parameter));
        }
        MethodNode call = answer.addMethod("call", 1, ClassHelper.Boolean_TYPE, closureParameters.toArray(Parameter.EMPTY_ARRAY), ClassNode.EMPTY_ARRAY, GeneralUtils.returnS(GeneralUtils.callThisX("doCall", arguments)));
        call.setSourcePosition(expression);
        call.setSynthetic(true);
        BlockStatement block = GeneralUtils.block(new Statement[0]);
        VariableExpression outer = GeneralUtils.varX("_outerInstance");
        outer.setSourcePosition(expression);
        block.getVariableScope().putReferencedLocalVariable(outer);
        VariableExpression thisObject = GeneralUtils.varX("_thisObject");
        thisObject.setSourcePosition(expression);
        block.getVariableScope().putReferencedLocalVariable(thisObject);
        block.addStatement(GeneralUtils.stmt(GeneralUtils.ctorSuperX(GeneralUtils.args(outer, thisObject))));
        Parameter[] ctorParams = new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE, "_outerInstance"), new Parameter(ClassHelper.OBJECT_TYPE, "_thisObject")};
        ConstructorNode ctor = answer.addConstructor(1, ctorParams, ClassNode.EMPTY_ARRAY, block);
        ctor.setSourcePosition(expression);
        this.correctAccessedVariable(doCall, expression);
        return answer;
    }

    private void removeParameter(String name, List<Parameter> parameters) {
        parameters.removeIf(parameter -> parameter.getName().equals(name));
    }

    private ClassNode getOutermostClass(ClassNode outermostClass) {
        while (outermostClass instanceof InnerClassNode) {
            outermostClass = outermostClass.getOuterClass();
        }
        return outermostClass;
    }

    private void correctAccessedVariable(final MethodNode methodNode, ClosureExpression ce) {
        CodeVisitorSupport visitor = new CodeVisitorSupport(){

            @Override
            public void visitVariableExpression(VariableExpression expression) {
                Variable v = expression.getAccessedVariable();
                if (v == null) {
                    return;
                }
                String name = expression.getName();
                if (v instanceof DynamicVariable) {
                    for (Parameter param : methodNode.getParameters()) {
                        if (!name.equals(param.getName())) continue;
                        expression.setAccessedVariable(param);
                    }
                }
            }
        };
        visitor.visitClosureExpression(ce);
    }

    private String getClosureInnerName(ClassNode owner, ClassNode enclosingClass) {
        String ownerShortName = owner.getNameWithoutPackage();
        Object classShortName = enclosingClass.getNameWithoutPackage();
        classShortName = ((String)classShortName).equals(ownerShortName) ? "" : (String)classShortName + "_";
        int dp = ((String)classShortName).lastIndexOf("$");
        if (dp >= 0) {
            classShortName = ((String)classShortName).substring(++dp);
        }
        if (((String)classShortName).startsWith("_")) {
            classShortName = ((String)classShortName).substring(1);
        }
        return "_gc_" + (String)classShortName + "closure" + this.closureCount++;
    }
}

