/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.ast.visitor;

import java.util.ArrayList;
import org.apache.groovy.contracts.ast.visitor.BaseVisitor;
import org.apache.groovy.contracts.common.spi.Lifecycle;
import org.apache.groovy.contracts.common.spi.ProcessingContextInformation;
import org.apache.groovy.contracts.util.LifecycleImplementationLoader;
import org.apache.groovy.contracts.util.Validate;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;

public class LifecycleBeforeTransformationVisitor
extends BaseVisitor {
    private final ProcessingContextInformation pci;

    public LifecycleBeforeTransformationVisitor(SourceUnit sourceUnit, ReaderSource source, ProcessingContextInformation pci) {
        super(sourceUnit, source);
        Validate.notNull(pci);
        this.pci = pci;
    }

    @Override
    public void visitClass(ClassNode node) {
        super.visitClass(node);
        ArrayList<MethodNode> methods = new ArrayList<MethodNode>(node.getMethods());
        ArrayList<ConstructorNode> constructors = new ArrayList<ConstructorNode>(node.getDeclaredConstructors());
        for (Lifecycle lifecyle : LifecycleImplementationLoader.load(Lifecycle.class, this.getClass().getClassLoader())) {
            lifecyle.beforeProcessingClassNode(this.pci, node);
            for (MethodNode methodNode : constructors) {
                lifecyle.beforeProcessingConstructorNode(this.pci, node, methodNode);
            }
            for (MethodNode methodNode : methods) {
                lifecyle.beforeProcessingMethodNode(this.pci, node, methodNode);
            }
        }
    }
}

