/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.ast.visitor;

import java.util.List;
import org.apache.groovy.contracts.ast.visitor.BaseVisitor;
import org.apache.groovy.contracts.generation.BaseGenerator;
import org.apache.groovy.contracts.generation.CandidateChecks;
import org.apache.groovy.contracts.util.AnnotationUtils;
import org.apache.groovy.util.BeanUtils;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;

public class DynamicSetterInjectionVisitor
extends BaseVisitor {
    private static final String SPRING_STEREOTYPE_PACKAGE = "org.springframework.stereotype";
    private BlockStatement invariantAssertionBlockStatement;

    public DynamicSetterInjectionVisitor(SourceUnit sourceUnit, ReaderSource source) {
        super(sourceUnit, source);
    }

    protected Statement createSetterBlock(ClassNode classNode, FieldNode field, Parameter parameter) {
        return GeneralUtils.block(this.invariantAssertionBlockStatement, GeneralUtils.assignS(GeneralUtils.fieldX(field), GeneralUtils.varX(parameter)), this.invariantAssertionBlockStatement);
    }

    @Override
    public void visitProperty(PropertyNode node) {
        ClassNode classNode = node.getDeclaringClass();
        String setterName = "set" + BeanUtils.capitalize(node.getName());
        Statement setterBlock = node.getSetterBlock();
        Parameter parameter = GeneralUtils.param(node.getType(), "value");
        if (CandidateChecks.isClassInvariantCandidate(node) && setterBlock == null && classNode.getMethod(setterName, new Parameter[]{parameter}) == null) {
            Statement setterBlockStatement = this.createSetterBlock(classNode, node.getField(), parameter);
            node.setSetterBlock(setterBlockStatement);
        }
    }

    @Override
    public void visitClass(ClassNode classNode) {
        MethodNode invariantMethodNode = BaseGenerator.getInvariantMethodNode(classNode);
        if (invariantMethodNode == null || AnnotationUtils.hasAnnotationOfType(classNode, SPRING_STEREOTYPE_PACKAGE)) {
            return;
        }
        this.invariantAssertionBlockStatement = GeneralUtils.block(GeneralUtils.stmt(GeneralUtils.callThisX(invariantMethodNode.getName())));
        List<ConstructorNode> declaredConstructors = classNode.getDeclaredConstructors();
        if (declaredConstructors == null || declaredConstructors.isEmpty()) {
            ConstructorNode constructor = new ConstructorNode(1, this.invariantAssertionBlockStatement);
            constructor.setSynthetic(true);
            classNode.addConstructor(constructor);
        }
        super.visitClass(classNode);
    }
}

