/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.ast.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.groovy.contracts.ClassInvariantViolation;
import org.apache.groovy.contracts.PostconditionViolation;
import org.apache.groovy.contracts.PreconditionViolation;
import org.apache.groovy.contracts.annotations.meta.ContractElement;
import org.apache.groovy.contracts.annotations.meta.Postcondition;
import org.apache.groovy.contracts.ast.visitor.ASTNodeMetaData;
import org.apache.groovy.contracts.ast.visitor.BaseVisitor;
import org.apache.groovy.contracts.classgen.asm.ContractClosureWriter;
import org.apache.groovy.contracts.generation.AssertStatementCreationUtility;
import org.apache.groovy.contracts.generation.CandidateChecks;
import org.apache.groovy.contracts.generation.TryCatchBlockGenerator;
import org.apache.groovy.contracts.util.AnnotationUtils;
import org.apache.groovy.contracts.util.ExpressionUtils;
import org.apache.groovy.contracts.util.FieldValues;
import org.apache.groovy.contracts.util.Validate;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.TransformingCodeVisitor;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.Types;

public class AnnotationClosureVisitor
extends BaseVisitor
implements ASTNodeMetaData {
    public static final String META_DATA_USE_EXECUTION_TRACKER = "org.apache.groovy.contracts.META_DATA.USE_EXECUTION_TRACKER";
    public static final String META_DATA_ORIGINAL_TRY_CATCH_BLOCK = "org.apache.groovy.contracts.META_DATA.ORIGINAL_TRY_CATCH_BLOCK";
    private static final String POSTCONDITION_TYPE_NAME = Postcondition.class.getName();
    private static final ClassNode FIELD_VALUES = ClassHelper.makeCached(FieldValues.class);
    private ClassNode classNode;
    private final ContractClosureWriter contractClosureWriter = new ContractClosureWriter();

    public AnnotationClosureVisitor(SourceUnit sourceUnit, ReaderSource source) {
        super(sourceUnit, source);
    }

    @Override
    public void visitClass(ClassNode classNode) {
        if (classNode == null || !CandidateChecks.isContractsCandidate(classNode) && !CandidateChecks.isInterfaceContractsCandidate(classNode)) {
            return;
        }
        this.classNode = classNode;
        if (classNode.getNodeMetaData("org.apache.groovy.contracts.PROCESSED") == null) {
            List<AnnotationNode> annotationNodes = AnnotationUtils.hasMetaAnnotations(classNode, ContractElement.class.getName());
            for (AnnotationNode annotationNode : annotationNodes) {
                ClosureExpression closureExpression = AnnotationClosureVisitor.getOriginalCondition(annotationNode);
                if (closureExpression == null) continue;
                ClosureExpressionValidator validator = new ClosureExpressionValidator(classNode, null, annotationNode, this.sourceUnit);
                validator.visitClosureExpression(closureExpression);
                validator.secondPass(closureExpression);
                List<BooleanExpression> booleanExpressions = ExpressionUtils.getBooleanExpression(closureExpression);
                if (booleanExpressions == null || booleanExpressions.isEmpty()) continue;
                BlockStatement newClosureBlockStatement = TryCatchBlockGenerator.generateTryCatchBlock(ClassHelper.makeWithoutCaching(ClassInvariantViolation.class), "<" + annotationNode.getClassNode().getName() + "> " + classNode.getName() + " \n\n", AssertStatementCreationUtility.getAssertionStatements(booleanExpressions));
                newClosureBlockStatement.setSourcePosition(closureExpression.getCode());
                ClosureExpression rewrittenClosureExpression = new ClosureExpression(closureExpression.getParameters(), newClosureBlockStatement);
                rewrittenClosureExpression.setDeclaringClass(closureExpression.getDeclaringClass());
                rewrittenClosureExpression.setSourcePosition(closureExpression);
                rewrittenClosureExpression.setSynthetic(true);
                rewrittenClosureExpression.setVariableScope(closureExpression.getVariableScope());
                ClassNode closureClassNode = this.contractClosureWriter.createClosureClass(classNode, null, rewrittenClosureExpression, false, false, 1);
                classNode.getModule().addClass(closureClassNode);
                BlockStatement block = TryCatchBlockGenerator.generateTryCatchBlockForInlineMode(ClassHelper.makeWithoutCaching(ClassInvariantViolation.class), "<" + annotationNode.getClassNode().getName() + "> " + classNode.getName() + " \n\n", AssertStatementCreationUtility.getAssertionStatements(booleanExpressions));
                block.setNodeMetaData(META_DATA_USE_EXECUTION_TRACKER, validator.isMethodCalls());
                ClassExpression value = GeneralUtils.classX(closureClassNode.getPlainNodeReference());
                value.setNodeMetaData(META_DATA_ORIGINAL_TRY_CATCH_BLOCK, block);
                value.setSourcePosition(annotationNode);
                AnnotationClosureVisitor.replaceCondition(annotationNode, value);
                this.markClosureReplaced(classNode);
            }
        }
        super.visitClass(classNode);
        this.visitClass(classNode.getSuperClass());
        for (ClassNode i : classNode.getInterfaces()) {
            this.visitClass(i);
        }
        this.markProcessed(classNode);
    }

    @Override
    public void visitConstructorOrMethod(MethodNode methodNode, boolean isConstructor) {
        if (methodNode.getNodeMetaData("org.apache.groovy.contracts.PROCESSED") != null || !CandidateChecks.couldBeContractElementMethodNode(this.classNode, methodNode) && !CandidateChecks.isPreconditionCandidate(this.classNode, methodNode)) {
            return;
        }
        List<AnnotationNode> annotationNodes = AnnotationUtils.hasMetaAnnotations(methodNode, ContractElement.class.getName());
        for (AnnotationNode annotationNode : annotationNodes) {
            this.replaceWithClosureClassReference(annotationNode, methodNode);
        }
        this.markProcessed(methodNode);
        super.visitConstructorOrMethod(methodNode, isConstructor);
    }

    private void replaceWithClosureClassReference(AnnotationNode annotationNode, MethodNode methodNode) {
        Validate.notNull(annotationNode);
        Validate.notNull(methodNode);
        ClosureExpression closureExpression = AnnotationClosureVisitor.getOriginalCondition(annotationNode);
        if (closureExpression == null) {
            return;
        }
        OldPropertyExpressionTransformer transformer = new OldPropertyExpressionTransformer(methodNode);
        TransformingCodeVisitor visitor = new TransformingCodeVisitor(transformer);
        visitor.visitClosureExpression(closureExpression);
        ClosureExpressionValidator validator = new ClosureExpressionValidator(this.classNode, methodNode, annotationNode, this.sourceUnit);
        validator.visitClosureExpression(closureExpression);
        validator.secondPass(closureExpression);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(Arrays.asList(closureExpression.getParameters()));
        parameters.addAll(Arrays.asList(methodNode.getParameters()));
        List<BooleanExpression> booleanExpressions = ExpressionUtils.getBooleanExpression(closureExpression);
        if (booleanExpressions == null || booleanExpressions.isEmpty()) {
            return;
        }
        boolean isConstructor = methodNode.isConstructor();
        boolean isPostcondition = AnnotationUtils.hasAnnotationOfType(annotationNode.getClassNode(), POSTCONDITION_TYPE_NAME);
        BlockStatement newClosureBlockStatement = TryCatchBlockGenerator.generateTryCatchBlock(isPostcondition ? ClassHelper.makeWithoutCaching(PostconditionViolation.class) : ClassHelper.makeWithoutCaching(PreconditionViolation.class), "<" + annotationNode.getClassNode().getName() + "> " + this.classNode.getName() + "." + methodNode.getTypeDescriptor() + " \n\n", AssertStatementCreationUtility.getAssertionStatements(booleanExpressions));
        newClosureBlockStatement.setSourcePosition(closureExpression.getCode());
        ClosureExpression rewrittenClosureExpression = new ClosureExpression(parameters.toArray(Parameter.EMPTY_ARRAY), newClosureBlockStatement);
        rewrittenClosureExpression.setDeclaringClass(closureExpression.getDeclaringClass());
        rewrittenClosureExpression.setSourcePosition(closureExpression);
        rewrittenClosureExpression.setSynthetic(true);
        rewrittenClosureExpression.setVariableScope(this.correctVariableScope(closureExpression.getVariableScope(), methodNode));
        ClassNode closureClassNode = this.contractClosureWriter.createClosureClass(this.classNode, methodNode, rewrittenClosureExpression, isPostcondition && !isConstructor, isPostcondition && !isConstructor, 1);
        this.classNode.getModule().addClass(closureClassNode);
        BlockStatement block = TryCatchBlockGenerator.generateTryCatchBlockForInlineMode(isPostcondition ? ClassHelper.makeWithoutCaching(PostconditionViolation.class) : ClassHelper.makeWithoutCaching(PreconditionViolation.class), "<" + annotationNode.getClassNode().getName() + "> " + this.classNode.getName() + "." + methodNode.getTypeDescriptor() + " \n\n", AssertStatementCreationUtility.getAssertionStatements(booleanExpressions));
        block.setNodeMetaData(META_DATA_USE_EXECUTION_TRACKER, validator.isMethodCalls());
        ClassExpression value = GeneralUtils.classX(closureClassNode.getPlainNodeReference());
        value.setNodeMetaData(META_DATA_ORIGINAL_TRY_CATCH_BLOCK, block);
        value.setSourcePosition(annotationNode);
        AnnotationClosureVisitor.replaceCondition(annotationNode, value);
        this.markClosureReplaced(methodNode);
    }

    private VariableScope correctVariableScope(VariableScope variableScope, MethodNode methodNode) {
        if (variableScope == null || methodNode == null || methodNode.getParameters() == null || methodNode.getParameters().length == 0) {
            return variableScope;
        }
        VariableScope copy = this.copy(variableScope);
        Iterator<Variable> iterator = variableScope.getReferencedClassVariablesIterator();
        while (iterator.hasNext()) {
            Variable variable = iterator.next();
            String name = variable.getName();
            for (Parameter parameter : methodNode.getParameters()) {
                if (!parameter.getName().equals(name)) continue;
                copy.putReferencedLocalVariable(parameter);
                break;
            }
            if (copy.isReferencedLocalVariable(name)) continue;
            copy.putReferencedClassVariable(variable);
        }
        return copy;
    }

    private VariableScope copy(VariableScope original) {
        VariableScope copy = new VariableScope(original.getParent());
        copy.setClassScope(original.getClassScope());
        copy.setInStaticContext(original.isInStaticContext());
        return copy;
    }

    private void markClosureReplaced(ASTNode someNode) {
        if (someNode.getNodeMetaData("org.apache.groovy.contracts.CLOSURE_REPLACED") == null) {
            someNode.setNodeMetaData("org.apache.groovy.contracts.CLOSURE_REPLACED", Boolean.TRUE);
        }
    }

    private void markProcessed(ASTNode someNode) {
        if (someNode.getNodeMetaData("org.apache.groovy.contracts.PROCESSED") == null) {
            someNode.setNodeMetaData("org.apache.groovy.contracts.PROCESSED", Boolean.TRUE);
        }
    }

    static class ClosureExpressionValidator
    extends ClassCodeVisitorSupport {
        private final ClassNode classNode;
        private final MethodNode methodNode;
        private final AnnotationNode annotationNode;
        private final SourceUnit sourceUnit;
        private final Map<VariableExpression, StaticMethodCallExpression> variableExpressions;
        private boolean secondPass = false;
        private boolean methodCalls = false;

        ClosureExpressionValidator(ClassNode classNode, MethodNode methodNode, AnnotationNode annotationNode, SourceUnit sourceUnit) {
            this.classNode = classNode;
            this.methodNode = methodNode;
            this.annotationNode = annotationNode;
            this.sourceUnit = sourceUnit;
            this.variableExpressions = new HashMap<VariableExpression, StaticMethodCallExpression>();
        }

        @Override
        public void visitClosureExpression(ClosureExpression expression) {
            this.secondPass = false;
            if (expression.getCode() == null || expression.getCode() instanceof EmptyStatement) {
                this.addError("[groovy-contracts] Annotation does not contain any expressions (e.g. use '@Requires({ argument1 })').", expression);
            }
            if (expression.getCode() instanceof BlockStatement && ((BlockStatement)expression.getCode()).getStatements().isEmpty()) {
                this.addError("[groovy-contracts] Annotation does not contain any expressions (e.g. use '@Requires({ argument1 })').", expression);
            }
            if (expression.isParameterSpecified() && !AnnotationUtils.hasAnnotationOfType(this.annotationNode.getClassNode(), POSTCONDITION_TYPE_NAME)) {
                this.addError("[groovy-contracts] Annotation does not support parameters (the only exception are postconditions).", expression);
            }
            if (expression.isParameterSpecified()) {
                for (Parameter param : expression.getParameters()) {
                    if (!"result".equals(param.getName()) && !"old".equals(param.getName())) {
                        this.addError("[groovy-contracts] Postconditions only allow 'old' and 'result' closure parameters.", expression);
                    }
                    if (param.isDynamicTyped()) continue;
                    this.addError("[groovy-contracts] Postconditions do not support explicit types.", expression);
                }
            }
            super.visitClosureExpression(expression);
        }

        @Override
        public void visitVariableExpression(VariableExpression expression) {
            Parameter parameter;
            FieldNode fieldNode;
            Variable accessedVariable = this.getParameterCandidate(expression.getAccessedVariable());
            if (accessedVariable instanceof FieldNode && (fieldNode = (FieldNode)accessedVariable).isPrivate() && !this.classNode.hasProperty(fieldNode.getName())) {
                StaticMethodCallExpression field = GeneralUtils.callX(FIELD_VALUES, "fieldValue", (Expression)GeneralUtils.args(VariableExpression.THIS_EXPRESSION, GeneralUtils.constX(fieldNode.getName()), GeneralUtils.classX(fieldNode.getType())));
                this.variableExpressions.put(expression, field);
            }
            if (accessedVariable instanceof Parameter && "it".equals((parameter = (Parameter)accessedVariable).getName())) {
                this.addError("[groovy-contracts] Access to 'it' is not supported.", expression);
            }
            expression.setAccessedVariable(accessedVariable);
            super.visitVariableExpression(expression);
        }

        @Override
        public void visitPostfixExpression(PostfixExpression expression) {
            VariableExpression variableExpression;
            this.checkOperation(expression, expression.getOperation());
            if (this.secondPass && expression.getExpression() instanceof VariableExpression && this.variableExpressions.containsKey(variableExpression = (VariableExpression)expression.getExpression())) {
                expression.setExpression(this.variableExpressions.get(variableExpression));
            }
            super.visitPostfixExpression(expression);
        }

        @Override
        public void visitPrefixExpression(PrefixExpression expression) {
            VariableExpression variableExpression;
            this.checkOperation(expression, expression.getOperation());
            if (this.secondPass && expression.getExpression() instanceof VariableExpression && this.variableExpressions.containsKey(variableExpression = (VariableExpression)expression.getExpression())) {
                expression.setExpression(this.variableExpressions.get(variableExpression));
            }
            super.visitPrefixExpression(expression);
        }

        @Override
        public void visitBinaryExpression(BinaryExpression expression) {
            this.checkOperation(expression, expression.getOperation());
            if (this.secondPass) {
                VariableExpression variableExpression;
                if (expression.getLeftExpression() instanceof VariableExpression && this.variableExpressions.containsKey(variableExpression = (VariableExpression)expression.getLeftExpression())) {
                    expression.setLeftExpression(this.variableExpressions.get(variableExpression));
                }
                if (expression.getRightExpression() instanceof VariableExpression && this.variableExpressions.containsKey(variableExpression = (VariableExpression)expression.getRightExpression())) {
                    expression.setRightExpression(this.variableExpressions.get(variableExpression));
                }
            }
            super.visitBinaryExpression(expression);
        }

        @Override
        public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
            this.methodCalls = true;
            super.visitStaticMethodCallExpression(call);
        }

        @Override
        public void visitMethodCallExpression(MethodCallExpression call) {
            this.methodCalls = true;
            super.visitMethodCallExpression(call);
        }

        @Override
        public void visitConstructorCallExpression(ConstructorCallExpression call) {
            this.methodCalls = true;
            super.visitConstructorCallExpression(call);
        }

        private void checkOperation(Expression expression, Token operation) {
            if (Types.ofType(operation.getType(), 1100)) {
                this.addError("[groovy-contracts] Assignment operators are not supported.", expression);
            }
            if (Types.ofType(operation.getType(), 1210)) {
                this.addError("[groovy-contracts] State changing postfix & prefix operators are not supported.", expression);
            }
        }

        private Variable getParameterCandidate(Variable variable) {
            if (variable == null || this.methodNode == null) {
                return variable;
            }
            if (variable instanceof Parameter) {
                return variable;
            }
            String name = variable.getName();
            for (Parameter param : this.methodNode.getParameters()) {
                if (!name.equals(param.getName())) continue;
                return param;
            }
            return variable;
        }

        public void secondPass(ClosureExpression closureExpression) {
            this.secondPass = true;
            super.visitClosureExpression(closureExpression);
        }

        public boolean isMethodCalls() {
            return this.methodCalls;
        }

        @Override
        protected SourceUnit getSourceUnit() {
            return this.sourceUnit;
        }
    }

    private static class OldPropertyExpressionTransformer
    extends ClassCodeExpressionTransformer {
        private final MethodNode methodNode;
        private CastExpression currentCast;

        OldPropertyExpressionTransformer(MethodNode methodNode) {
            this.methodNode = methodNode;
        }

        @Override
        protected SourceUnit getSourceUnit() {
            return null;
        }

        @Override
        public Expression transform(Expression expr) {
            VariableExpression varExpr;
            PropertyExpression propExpr;
            Expression objExpr;
            if (expr instanceof CastExpression) {
                CastExpression saved = this.currentCast;
                this.currentCast = (CastExpression)expr;
                Expression result = expr.transformExpression(this);
                this.currentCast = saved;
                return result;
            }
            if (expr instanceof PropertyExpression && expr.getNodeMetaData("org.apache.groovy.contracts.PROCESSED") == null && (this.currentCast == null || expr != this.currentCast.getExpression()) && (objExpr = (propExpr = (PropertyExpression)super.transform(expr)).getObjectExpression()) instanceof VariableExpression && "old".equals((varExpr = (VariableExpression)objExpr).getName())) {
                String propName = propExpr.getPropertyAsString();
                ClassNode declaringClass = this.methodNode.getDeclaringClass();
                if (declaringClass != null && declaringClass.getField(propName) != null) {
                    CastExpression adjusted = new CastExpression(declaringClass.getField(propName).getType(), expr);
                    adjusted.setSourcePosition(expr);
                    expr.setNodeMetaData("org.apache.groovy.contracts.PROCESSED", Boolean.TRUE);
                    return adjusted;
                }
            }
            return expr.transformExpression(this);
        }
    }
}

