/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.ast;

import groovy.contracts.Contracted;
import org.apache.groovy.contracts.ast.BaseASTTransformation;
import org.apache.groovy.contracts.ast.visitor.AnnotationProcessorVisitor;
import org.apache.groovy.contracts.ast.visitor.DomainModelInjectionVisitor;
import org.apache.groovy.contracts.ast.visitor.DynamicSetterInjectionVisitor;
import org.apache.groovy.contracts.ast.visitor.LifecycleAfterTransformationVisitor;
import org.apache.groovy.contracts.ast.visitor.LifecycleBeforeTransformationVisitor;
import org.apache.groovy.contracts.common.spi.ProcessingContextInformation;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.INSTRUCTION_SELECTION)
public class GContractsASTTransformation
extends BaseASTTransformation {
    @Override
    public void visit(ASTNode[] nodes, SourceUnit unit) {
        ModuleNode moduleNode = unit.getAST();
        ReaderSource source = this.getReaderSource(unit);
        ClassNode contractedAnnotationClassNode = ClassHelper.makeWithoutCaching(Contracted.class);
        for (ClassNode classNode : moduleNode.getClasses()) {
            if (classNode.getAnnotations(contractedAnnotationClassNode).isEmpty()) continue;
            ProcessingContextInformation pci = new ProcessingContextInformation(classNode, unit, source);
            new LifecycleBeforeTransformationVisitor(unit, source, pci).visitClass(classNode);
            new AnnotationProcessorVisitor(unit, source, pci).visitClass(classNode);
            new DomainModelInjectionVisitor(unit, source, pci).visitClass(classNode);
            new LifecycleAfterTransformationVisitor(unit, source, pci).visitClass(classNode);
            new DynamicSetterInjectionVisitor(unit, source).visitClass(classNode);
        }
    }
}

