/*
 * Decompiled with CFR 0.152.
 */
package groovy.console.ui.text;

import groovy.console.ui.text.SmartDocumentFilter;
import groovy.lang.Tuple;
import groovy.lang.Tuple2;
import groovy.lang.Tuple3;
import groovyjarjarantlr4.v4.runtime.Token;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.apache.groovy.util.Maps;

public class MatchingHighlighter
implements CaretListener {
    private final SmartDocumentFilter smartDocumentFilter;
    private final JTextPane textEditor;
    private final DefaultStyledDocument doc;
    private static final Map<String, Tuple3<Integer, List<Integer>, Boolean>> PAREN_MAP = Maps.of("(", Tuple.tuple(87, Collections.singletonList(88), true), ")", Tuple.tuple(88, Collections.singletonList(87), false), "?[", Tuple.tuple(71, Collections.singletonList(92), true), "[", Tuple.tuple(91, Collections.singletonList(92), true), "]", Tuple.tuple(92, Arrays.asList(91, 71), false), "{", Tuple.tuple(89, Collections.singletonList(90), true), "}", Tuple.tuple(90, Collections.singletonList(89), false));
    private volatile List<Tuple3<Integer, Position, Integer>> highlightedTokenInfoList = Collections.emptyList();
    private final StyleContext styleContext = StyleContext.getDefaultStyleContext();
    private final Style defaultStyle = this.styleContext.getStyle("default");

    public MatchingHighlighter(SmartDocumentFilter smartDocumentFilter, JTextPane textEditor) {
        this.smartDocumentFilter = smartDocumentFilter;
        this.textEditor = textEditor;
        this.doc = (DefaultStyledDocument)textEditor.getStyledDocument();
        this.initStyles();
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.highlight();
    }

    public void highlight() {
        SwingUtilities.invokeLater(this::doHighlight);
    }

    private void doHighlight() {
        this.clearHighlighted();
        if (!this.smartDocumentFilter.isLatest()) {
            return;
        }
        int caretPosition = this.textEditor.getCaretPosition();
        int f = -1;
        String c = null;
        for (int len = 2; len >= 1; --len) {
            try {
                f = caretPosition - len;
                c = this.doc.getText(f, len);
                if (PAREN_MAP.containsKey(c)) {
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            try {
                f = caretPosition;
                c = this.doc.getText(f, len);
                if (PAREN_MAP.containsKey(c)) {
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (2 != len) continue;
            try {
                f = caretPosition - 1;
                c = this.doc.getText(f, len);
                if (!PAREN_MAP.containsKey(c)) continue;
                break;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (!PAREN_MAP.containsKey(c)) {
            return;
        }
        int offset = f;
        String p = c;
        this.highlightMatched(offset, p);
    }

    private void highlightMatched(int offset, String p) {
        List<Token> latestTokenList = this.smartDocumentFilter.getLatestTokenList();
        Tuple3<Integer, List<Integer>, Boolean> tokenTypeTuple = PAREN_MAP.get(p);
        int triggerTokenType = tokenTypeTuple.getV1();
        List<Integer> matchedTokenTypeList = tokenTypeTuple.getV2();
        boolean normalOrder = tokenTypeTuple.getV3();
        ArrayDeque<Tuple2<Token, Boolean>> stack = new ArrayDeque<Tuple2<Token, Boolean>>();
        Token triggerToken = null;
        Token matchedToken = null;
        ListIterator<Token> iterator = latestTokenList.listIterator(normalOrder ? 0 : latestTokenList.size());
        while (normalOrder ? iterator.hasNext() : iterator.hasPrevious()) {
            Tuple2 tokenAndTriggerFlagTuple;
            Token token = normalOrder ? iterator.next() : iterator.previous();
            int tokenType = token.getType();
            if (tokenType == triggerTokenType) {
                Boolean triggerFlag = offset == token.getStartIndex();
                stack.push(Tuple.tuple(token, triggerFlag));
                continue;
            }
            if (!matchedTokenTypeList.contains(tokenType) || stack.isEmpty() || !((Boolean)(tokenAndTriggerFlagTuple = (Tuple2)stack.pop()).getV2()).booleanValue()) continue;
            triggerToken = (Token)tokenAndTriggerFlagTuple.getV1();
            matchedToken = token;
            break;
        }
        if (null != triggerToken && null != matchedToken) {
            this.highlightToken(p, triggerToken);
            this.highlightToken(p, matchedToken);
            try {
                this.highlightedTokenInfoList = Arrays.asList(Tuple.tuple(triggerToken.getType(), this.doc.createPosition(triggerToken.getStartIndex()), triggerToken.getText().length()), Tuple.tuple(matchedToken.getType(), this.doc.createPosition(matchedToken.getStartIndex()), matchedToken.getText().length()));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    private void initStyles() {
        PAREN_MAP.keySet().forEach(e -> this.createHighlightedStyleByParen((String)e));
    }

    private void createHighlightedStyleByParen(String p) {
        Style style = StyleContext.getDefaultStyleContext().addStyle(MatchingHighlighter.highlightedStyleName(p), this.findStyleByTokenType(PAREN_MAP.get(p).getV1()));
        StyleConstants.setForeground(style, Color.YELLOW.darker());
        StyleConstants.setBold(style, true);
    }

    private static String highlightedStyleName(String p) {
        return "highlighted" + p;
    }

    private Style findHighlightedStyleByParen(String p) {
        Style style = this.styleContext.getStyle(MatchingHighlighter.highlightedStyleName(p));
        return null == style ? this.defaultStyle : style;
    }

    private Style findStyleByTokenType(int tokenType) {
        Style style = this.styleContext.getStyle(String.valueOf(tokenType));
        return null == style ? this.defaultStyle : style;
    }

    private void highlightToken(String p, Token tokenToHighlight) {
        Style style = this.findHighlightedStyleByParen(p);
        this.doc.setCharacterAttributes(tokenToHighlight.getStartIndex(), tokenToHighlight.getText().length(), style, true);
    }

    private void clearHighlighted() {
        if (!this.highlightedTokenInfoList.isEmpty()) {
            for (Tuple3<Integer, Position, Integer> highlightedTokenInfo : this.highlightedTokenInfoList) {
                this.doc.setCharacterAttributes(highlightedTokenInfo.getV2().getOffset(), highlightedTokenInfo.getV3(), this.findStyleByTokenType(highlightedTokenInfo.getV1()), true);
            }
            this.highlightedTokenInfoList = Collections.emptyList();
        }
    }
}

